import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_refresher.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service_master/add_service_master/add_service_master_page.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service_master/edit_service_master/edit_service_master_page.dart';
import 'package:admin_desktop/presentation/theme/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_staggered_animations/flutter_staggered_animations.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../../../comments/widgets/no_item.dart';
import 'riverpod/service_master/edit/edit_service_master_provider.dart';
import 'riverpod/service_master/service_master_provider.dart';
import 'widgets/service_master_item.dart';

class ServiceMasterPage extends ConsumerStatefulWidget {
  final int masterId;
  const ServiceMasterPage({super.key,required this.masterId, });

  @override
  ConsumerState<ServiceMasterPage> createState() => _ServicePageState();
}

class _ServicePageState extends ConsumerState<ServiceMasterPage> {
  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (d) {
        ref
            .read(serviceMasterProvider.notifier)
            .fetchServices(context: context, isRefresh: true,masterId: widget.masterId);
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(serviceMasterProvider);
    final notifier = ref.read(serviceMasterProvider.notifier);
    return Directionality(
      textDirection:
          LocalStorage.getLangLtr() ? TextDirection.ltr : TextDirection.rtl,
      child: CustomScaffold(
        body: (CustomColorSet colors) {
          return Column(
            children: [
              Row(
                children: [

                  Text(
                    AppHelpers.getTranslation(TrKeys.serviceToMasters),
                    style: Style.interMedium(size: 20),
                  ),
                  const Spacer(),

                  Column(
                    children: [
                      5.verticalSpace,
                      CustomRefresher(
                          onTap: () {
                            notifier.fetchServices(
                                context: context, isRefresh: true,masterId: widget.masterId);
                          },
                          isLoading: state.isLoading),
                    ],
                  ),
                  10.horizontalSpace,
                  ref.watch(editMastersProvider).status!="accepted" ? SizedBox.shrink() :
                  Padding(
                    padding: const EdgeInsets.all(12.0),
                    child: LoginButton(

                      bgColor: Style.black,
                      icon: Icon(
                        Remix.add_circle_line,
                        color: Style.white,
                        size: 24.r,
                      ),
                      onPressed: () {
                        showDialog(
                            context: context,
                            builder: (_) {
                              return Dialog(
                                  backgroundColor: Style.transparent,
                                  child: AddServiceMasterPage());
                            });
                      },
                      title:AppHelpers.getTranslation(TrKeys.addService),
                    ),
                  ),
                ],
              ),
              Expanded(
                child: state.isLoading
                    ? ListView.builder(
                        physics: const NeverScrollableScrollPhysics(),
                        shrinkWrap: true,
                        itemCount: 6,
                        itemBuilder: (context, index) {
                          return Column(
                            children: [
                              Container(
                                width: double.infinity,
                                height: 72,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(AppConstants.radius),
                                  color: Style.shimmerBase,
                                ),
                              ),
                              const Divider(height: 2, color: Style.white),
                            ],
                          );
                        })
                    : state.services.isEmpty
                        ? const NoItem(title: TrKeys.noService)
                        : SingleChildScrollView(
                            child: Column(
                              children: [
                                AnimationLimiter(
                                  child: ListView.builder(
                                    physics:
                                        const NeverScrollableScrollPhysics(),
                                    padding: REdgeInsets.only(
                                        top: 16,
                                        bottom: 56.r,
                                        left: 12,
                                        right: 12),
                                    shrinkWrap: true,
                                    itemCount: state.services.length,
                                    itemBuilder: (context, index) =>
                                        AnimationConfiguration.staggeredList(
                                      position: index,
                                      duration: AppConstants.animationDuration,
                                      child: ScaleAnimation(
                                        scale: 0.5,
                                        child: FadeInAnimation(
                                          child: ServiceMasterItem(
                                            service: state.services[index],
                                            spacing: 10,
                                            status: ref.watch(editMastersProvider).status,
                                            onTap: () {
                                              // refreshController.resetNoData();
                                              ref
                                                  .read(
                                                      editServiceMasterProvider
                                                          .notifier)
                                                  .setDetails(
                                                    state.services[index],
                                                  );
                                              showDialog(
                                                  context: context,
                                                  builder: (_) {
                                                    return Dialog(
                                                        backgroundColor: Style.transparent,
                                                        child: EditServiceMasterPage());
                                                  });
                                            },
                                            onDelete: () {
                                              notifier.deleteService(
                                                context,
                                                state.services[index].id,
                                              );
                                            },
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                                16.verticalSpace,
                                if (state.hasMore)
                                  HasMoreButton(
                                    hasMore: state.hasMore,
                                    onViewMore: () {
                                      notifier.fetchServices(context: context,masterId:widget.masterId);
                                    },
                                  )
                              ],
                            ),
                          ),
              ),
            ],
          );
        },
      ),
    );
  }
}
